#include <linux/scc.h>

/********* CONFIGURATION PARAMATERES; PLEASE CHANGE THIS TO YOUR OWN SITUATION **********/

/* SCC hardware parameters */

#define NCHIPS	2		/* number of chips */
#define IOBASE	0x150    	/* base of first chip */
#define SPACE	4		/* spacing between chips */
#define AOFF	2		/* offset to channel A ctrl */
#define BOFF	0		/* offset to channel B ctrl */
#define DOFF	1		/* offset from ctrl to data */
#define INTACK	0x168  		/* INTACK ioport (vectored) or 0 for no INTACK (polling) */
#define IVEC	7		/* interrupt vector number */
#define CLK	4915200		/* clock frequency */
#define PCLK	1		/* PCLK or RTxC for clock */
#define HWTYPE	HWSCC		/* selection of special hardware types (see list below) */
#define HWPARAM 0		/* extra parameter for special hardware */

/* use the following hardware types: 
 *
 *	HWSCC		OptoSCC (PA0HZP)
 *	HWEAGLE         EAGLE
 *	HWPC100         PC100 
 *	HWPRIMUS        PRIMUS-PC (DG9BL)
 *	HWDRSI          DRSI PC*Packet
 *	HWBAYCOM        BayCom (U)SCC
 *	
 */
	
	

/* set to '1' if your card has an fullduplex divider */

/*		Channel  A  B	      Chip	*/
/*			======      ========   	*/
int SCC_Fulldup[8] =	{1, 1,  /* ...one...	*/
		   	 1, 1,  /* ...two...	*/
		   	 1, 1,  /* ...three...	*/
		   	 1, 1}; /* ...four...	*/
		   	 
/* set to '1' if your modem supports external clocking */

/*		Channel  A  B	      Chip	*/
/*			======      ========   	*/
int SCC_Extclk[8] =	{0, 0,	/* ...one...	*/
			 0, 0,  /* ...two...	*/
			 0, 0,  /* ...three...	*/
			 0, 0};	/* ...four...	*/

/* set to '1' if your modem uses NRZ instead of NRZI coding */

/*		Channel  A  B	      Chip	*/
/*			======	    =========	*/
int SCC_NRZ[8] =	{0, 0,	/* ...one...	*/
			 0, 0,  /* ...two...	*/
			 0, 0,	/* ...three...	*/
			 0, 0}; /* ...four...	*/

/* set to '1' if you have and want ESCC chip (8580/85180/85280) support */

/*		Channel  A  B	      Chip	*/
/*			======      ========   	*/
int SCC_Enhanced[8] =	{0, 0,	/* ...one...	*/
			 0, 0,  /* ...two...	*/
			 0, 0,  /* ...three...	*/
			 0, 0};	/* ...four...	*/


/* SCC driver parameters */

#define MAXSCC		4	/* maximal number of SCC chips supported */
#define BUFSIZE		127	/* minimal pre-allocated memory per buffer */
				/* (must not exceed 4096) */
#define TPS             25  	/* scc_timer ticks per second */


