/******************************************************************************/
/*                                                                            */
/*  Title       : shuttle.h                                                   */
/*  Author      : Manfred Bester                                              */
/*  Date        : 26Nov94                                                     */
/*  Last change : 15Mar95                                                     */
/*                                                                            */
/*  Synopsis    : This include file contains the point arrays for the         */
/*                space shuttle icon.                                         */
/*                                                                            */
/*                                                                            */
/*  SatTrack is Copyright (c) 1992, 1993, 1994, 1995 by Manfred Bester.       */
/*  All Rights Reserved.                                                      */
/*                                                                            */
/*  Permission to use, copy, and distribute SatTrack and its documentation    */
/*  in its entirety for educational, research and non-profit purposes,        */
/*  without fee, and without a written agreement is hereby granted, provided  */
/*  that the above copyright notice and the following three paragraphs appear */
/*  in all copies. SatTrack may be modified for personal purposes, but        */
/*  modified versions may NOT be distributed without prior consent of the     */
/*  author.                                                                   */
/*                                                                            */
/*  Permission to incorporate this software into commercial products may be   */
/*  obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way,    */
/*  Berkeley, CA 94709, USA. Note that distributing SatTrack 'bundled' in     */
/*  with ANY product is considered to be a 'commercial purpose'.              */
/*                                                                            */
/*  IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, */
/*  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF   */
/*  THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED  */
/*  OF THE POSSIBILITY OF SUCH DAMAGE.                                        */
/*                                                                            */
/*  THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT      */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A   */
/*  PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"      */
/*  BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT, */
/*  UPDATES, ENHANCEMENTS, OR MODIFICATIONS.                                  */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* space shuttle icon                                                         */
/*                                                                            */
/******************************************************************************/

XPoint stsPointsWhite[] = {

{ 17, 2},                                               /* crew cabin */
{ 17, 1}, { 16, 1}, { 15, 1}, { 14, 1}, { 13, 1},
{ 17, 0}, { 16, 0}, { 15, 0}, { 14, 0}, { 13, 0},
{ 20,-1}, { 19,-1}, { 18,-1},
{ 17,-1}, { 16,-1}, { 15,-1}, { 14,-1}, { 13,-1},
{ 13,-2},
{ 17,-3}, { 16,-3}, { 15,-3}, { 14,-3}, { 13,-3},

{ 12, 1}, { 11, 1}, { 10, 1}, {  9, 1}, {  8, 1},       /* cargo bay */
{  7, 1}, {  6, 1}, {  5, 1}, {  4, 1}, {  3, 1},
{  2, 1}, {  1, 1}, {  0, 1}, { -1, 1}, { -2, 1},
{ -3, 1}, { -4, 1}, { -5, 1}, { -6, 1}, { -7, 1}, 
{ -8, 1}, { -9, 1}, 

{ 12, 0}, { 11, 0}, { 10, 0}, {  9, 0}, {  8, 0},
{  7, 0}, {  6, 0}, {  5, 0}, {  4, 0}, {  3, 0},
{  2, 0}, {  1, 0}, {  0, 0}, { -1, 0}, { -2, 0},
{ -3, 0}, { -4, 0}, { -5, 0}, { -6, 0}, { -7, 0}, 
{ -8, 0}, { -9, 0}, 

{ 12,-1}, { 11,-1}, { 10,-1}, {  9,-1}, {  8,-1},
{  7,-1}, {  6,-1}, {  5,-1}, {  4,-1}, {  3,-1},
{  2,-1}, {  1,-1}, {  0,-1}, { -1,-1}, { -2,-1},
{ -3,-1}, { -4,-1}, { -5,-1}, { -6,-1}, { -7,-1}, { -8,-1}, 

{ 12,-2}, { 11,-2}, { 10,-2}, {  9,-2}, {  8,-2},
{  7,-2}, {  6,-2}, {  5,-2}, {  4,-2}, {  3,-2},
{  2,-2}, {  1,-2}, {  0,-2}, { -1,-2}, { -2,-2},
{ -3,-2}, { -4,-2}, { -5,-2}, { -6,-2}, { -7,-2}, { -8,-2}, 

{ 12,-3}, { 11,-3}, { 10,-3}, {  9,-3}, {  8,-3},
{  7,-3}, {  6,-3}, {  5,-3}, {  4,-3}, {  3,-3},
{  2,-3}, {  1,-3}, {  0,-3}, { -1,-3}, { -2,-3},
{ -3,-3}, { -4,-3}, { -5,-3}, { -6,-3}, { -7,-3}, { -8,-3}, 

{-10, 2}, {-11, 2}, {-12, 2},                           /* rear section */
{-10, 1}, {-11, 1}, {-12, 1}, {-13, 1}, {-14, 1}, {-15, 1}, 
{-10, 0}, {-11, 0}, {-12, 0}, {-13, 0},
{-10,-1}, {-11,-1}, {-12,-1}, {-13,-1},
{-10,-2}, {-11,-2}, {-12,-2}, {-13,-2}, {-14,-2}, {-15,-2}, 
{-10,-3}, {-11,-3}, {-12,-3}, {-13,-3}, {-14,-3}, {-15,-3}, 
{-10,-4}, {-11,-4}, {-12,-4}, {-13,-4}, {-14,-4}, {-15,-4}, 

{-12, -5}, {-13, -5}, {-14, -5}, {-15, -5},             /* tail fin */
{-12, -6}, {-13, -6}, {-14, -6}, {-15, -6}, {-16, -6}, 
{-13, -7}, {-14, -7}, {-15, -7}, {-16, -7}, {-17, -7}, 
{-14, -8}, {-15, -8}, {-16, -8}, {-17, -8}, {-18, -8},
{-15, -9}, {-16, -9}, {-17, -9}, {-18, -9},
{-16,-10}, {-17,-10}, {-18,-10}, {-19,-10},
{-17,-11}, {-18,-11}, {-19,-11}, 
{-18,-12}, {-19,-12}, {-20,-12}
};


XPoint stsPointsBlack[] = {

{ 24, 3}, { 23, 3}, { 22, 3}, { 21, 3}, { 20, 3},       /* bottom row */
{ 19, 3}, { 18, 3}, { 17, 3}, { 16, 3}, { 15, 3},
{ 14, 3}, { 13, 3}, { 12, 3}, { 11, 3}, { 10, 3},
{  9, 3}, {  8, 3}, {  7, 3}, {  6, 3}, {  5, 3},
{  4, 3}, {  3, 3}, {  2, 3}, {  1, 3}, {  0, 3},
{ -1, 3}, { -2, 3}, { -3, 3}, { -4, 3}, { -5, 3},
{ -6, 3}, { -7, 3}, { -8, 3}, { -9, 3}, {-10, 3},
{-11, 3}, {-12, 3}, {-13, 3}, {-14, 3}, {-15, 3},
{-16, 3}, {-17, 3}, {-18, 3}, {-19, 3}, {-20, 3},

{ 25, 2}, { 24, 2}, { 23, 2}, { 22, 2}, { 21, 2},       /* second from bottom */
{ 20, 2}, { 19, 2}, { 18, 2}, { 16, 2}, { 15, 2},
{ 14, 2}, { 13, 2}, { 12, 2}, { 11, 2}, { 10, 2},
{  9, 2}, {  8, 2}, {  7, 2}, {  6, 2}, {  5, 2},
{  4, 2}, {  3, 2}, {  2, 2}, {  1, 2}, {  0, 2},
{ -1, 2}, { -2, 2}, { -3, 2}, { -4, 2}, { -5, 2},
{ -6, 2}, { -7, 2}, { -8, 2}, { -9, 2}, {-13, 2}, 
{-14, 2}, {-15, 2},

{ 24, 1}, { 23, 1}, { 22, 1}, { 21, 1}, { 20, 1},       /* crew cabin area */
{ 19, 1}, { 18, 1}, 
{ 22, 0}, { 21, 0}, { 20, 0}, { 19, 0}, { 18, 0},
{ 18,-2}, { 17,-2}, { 16,-2}, { 15,-2}, { 14,-2},

{-19, 2},                                               /* main engines */
{-16, 1}, {-17, 1}, {-18, 1}, {-19, 1},
{-16, 0}, {-17, 0}, {-18, 0}, {-19, 0},
{-19,-1},
{-16,-2}, {-17,-2}, {-18,-2}, {-19,-2},
{-16,-3}, {-17,-3}, {-18,-3}, {-19,-3},
{-19,-4},

{-14, 0}, {-15, 0},                                     /* electrical panel */
{-14,-1}, {-15,-1},

{ -9,-1}, { -9,-2}, { -9,-3}, { -9,-4},                 /* rear of cargo bay */

{-10, -5}, {-11, -5}, {-11, -6}, {-12, -7}, {-13, -8}, 
{-14, -9}, {-15,-10}, {-16,-11}, {-17,-12}, 
{-18,-13}, {-19,-13}, {-20,-13}, {-21,-13}, 
{-21,-12}, {-20,-11}, {-20,-10}, {-19, -9},
{-19, -8}, {-18, -7}, {-18, -6}, {-17, -6}, {-16, -5}

};

/******************************************************************************/
/*                                                                            */
/* End of include file shuttle.h                                              */
/*                                                                            */
/******************************************************************************/
